<?php

namespace Tests\Unit;

use App\Facades\Settings;
use App\SiteRepository;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;
use App\Facades\Site;
use Tests\TestCase;

final class SiteRepositoryWwwTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testVehicleUrlWithWww()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'Vehicles',
            'name' => 'Include www in vehicle page URL path',
            'config_key' => 'vehicles-url-path-include-www',
            'type' => 'boolean',
            'value' => true,
        ]);

        $this->assertStringContainsString('www.', Site::vehicleUrl(Vehicle::factory()->create()));
    }

    public function testOfferUrlWithWww()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'Offers',
            'name' => 'Include www in offer page URL path',
            'config_key' => 'offers-url-path-include-www',
            'type' => 'boolean',
            'value' => true,
        ]);

        $offer = VehicleOffer::factory()->create();

        $url = Site::offerUrl($offer, true);

        $this->assertStringContainsString($offer->urlPath(), $url);
        $this->assertStringContainsString('www.', $url);
    }
}
