<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiryVehicleStatsDaysSettingSeeder extends Seeder
{
    public function run(): void
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Enquiries',
                'group' => 'Response',
                'name' => 'Vehicle stats days lookback',
                'description' => 'Number of days to look back when counting vehicle views for enquiry stats',
                'config_key' => 'crm-enquiry-vehicle-stats-days',
                'type' => 'number',
                'value' => 7,
                'order' => 12,
                'feature' => 'enquiry-vehicle-stats',
            ],
        ];
    }
}
