<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class WebLeadsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'WebLeads',
                'name' => 'Enabled',
                'config_key' => 'crm-webleads-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'WebLeads',
                'name' => 'API Key',
                'config_key' => 'crm-webleads-api-key',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.crm-webleads-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'WebLeads',
                'name' => 'API Domain',
                'config_key' => 'crm-webleads-api-domain',
                'type' => 'string',
                'value' => 'https://mobapps.eu.keyloop.io',
                'validation_rules' => [
                    "required_if:values.crm-webleads-enabled,true"
                ],
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'WebLeads',
                'name' => 'Fallback Dealer ID',
                'config_key' => 'crm-webleads-fallback-dealer-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.crm-webleads-enabled,true"
                ],
            ],
        ];
    }
}
