<?php

namespace App\Contracts;

interface LeaseDataProvider
{
    /**
     * Check if lease data provider is enabled
     *
     * @return bool
     */
    public function enabled(): bool;

    /**
     * Name of the lease data provider
     *
     * @return string
     */
    public function name(): string;

    /**
     * Import lease data from the provider
     *
     */
    public function runScheduledImport(): void;
}
