<?php

namespace App\Jobs;

use App\Facades\Settings;
use App\Services\AutoTraderHub;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class ExportVehicleBatchToAutoTraderHub implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(private readonly Collection $vehicles, private readonly AutoTraderHub $service)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->vehicles->load([
            'mediaUses.media',
            'dealership',
            'make',
            'model',
            'transmission',
            'drivetrain',
            'fuelType',
            'bodyStyle',
            'features',
            'equipment',
        ]);
        $this->service->setToken(Settings::get('auto-trader-hub-token'))->bulkExport($this->vehicles);
    }
}
