<?php

namespace App\Modules\Leasing;

use App\Modules\Leasing\Jobs\ImportPriceMapJob;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeasePriceMapping;

class KeyloopFleetKompactPriceMapImporter extends KeyloopFleetKompactImporterBase
{
    protected function filter(Collection $data): bool
    {
        if (
            array_key_exists($data['fran'], $this->enabled_keyloop_makes)
            && array_key_exists($data['fran'], $this->enabled_keyloop_models)
            && array_key_exists($data['model-code'], $this->enabled_keyloop_models[$data['fran']])
        ) {
            return true;
        }

        return false;
    }

    protected function prepareForImport(): void
    {
        KeyloopLeasePriceMapping::query()->update([
            'was_recently_synced' => false,
        ]);
    }

    protected function importItems(Collection $data): void
    {
        $this->dispatch(new ImportPriceMapJob($data->map(fn ($item) => [
            'external_variant_id' => $item['variant'],
            'make_id' => $this->getVehicleMake($item['fran']),
            'model_id' => $this->getVehicleModel($item['model-code'], $item['fran']),
            'option_type' => $item['ctp'],
            'option_code' => $item['ctp-option'],
            'price_option_code' => $item['price-option'],
        ])));
    }
}
