<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\OutAndAboutExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class OutAndAbout implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-out-and-about-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.out_and_about');
    }

    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new OutAndAboutExportJob());
        }
    }
}
