<?php

namespace Tests\Tenant;

use App\Exports\OutAndAboutExport;
use App\Jobs\OutAndAboutExportJob;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;

class OutAndAboutExportTest extends TenantTestCase
{
    public function testData()
    {
        Vehicle::factory(5)->create([
            'is_published' => true,
        ]);

        $data = (new OutAndAboutExport())->getExportData();

        $this->assertCount(5, $data);
    }

    public function testExport()
    {
        Http::fake([
            '*' => Http::response(null, 200),
        ]);

        Vehicle::factory()->create([
            'is_published' => true,
            'uuid' => 12345
        ]);

        (new OutAndAboutExportJob())->handle();

        $this->assertCount(1, SalesChannelHistory::all());

        Http::assertSent(function (Request $request) {
            return Str::contains($request->body(), '<StockNumber>12345<\/StockNumber>');
        });
    }
}
