<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class DeployCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'deploy';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run deployment for changes';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->call('migrate', ['--force' => true]);
        $this->call('tenants:migrate', ['--force' => true]);
        $this->call(SeedGlobalData::class);
        $this->call(SeedTenantsCommand::class);
        $this->call('tenants:run', ['commandname' => 'vehicles:check-for-required-attributes']);
        return Command::SUCCESS;
    }
}
