<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CrossSellLocationSeeder extends Seeder
{
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Similar vehicle display locations',
                'config_key' => 'vehicles-cross-sell-location',
                'type' => 'string',
                'value' => 'all',
                'choices' => [
                    [
                        'value' => 'all',
                        'name' => 'All',
                    ],
                    [
                        'value' => 'srp',
                        'name' => 'SRP',
                    ],
                    [
                        'value' => 'fpa',
                        'name' => 'FPA',
                    ],
                ],
            ],
        ];
    }
}
