<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ImaginStudioSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Vehicle',
                'config_key' => 'imagin-placeholders-vehicle-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Offer',
                'config_key' => 'imagin-placeholders-offer-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'New Car',
                'config_key' => 'imagin-placeholders-new-car-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Valuation Lookup',
                'config_key' => 'imagin-placeholders-valuation-lookup-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
