<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PhyronImageSync3Seeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Remove images that are updated by Phyron version',
                'config_key' => 'image-sync-phryon-remove-replaced-images',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When enabled will remove the original images that were used for generating new version'
            ],
        ];
    }
}
