<?php

namespace App\ImportMaps;

use Illuminate\Database\Eloquent\Builder;
use Mtc\MercuryDataModels\VehicleOffer;

class VehicleOfferImportMap
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Vehicle Offers';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        $columns = [
            'uuid' => 'Unique Identifier',
            'slug' => 'Slug',
            'stock_provider' => 'Stock Provider',
            'vin' => 'VIN',
            'type_id' => 'Offer Type',
            'type' => 'Type (new/motability)',
            'vehicle_type' => 'Vehicle Type',
            'published' => 'Is Published',
            'published_at' => 'Published At',
            'unpublished_at' => 'Unpublished At',
            'featured' => 'Is Featured',
            'name' => 'Name',
            'derivative' => 'Derivative',
            'dealership_id' => 'Dealership',
            'template_id' => 'Template',
            'make_id' => 'Vehicle Make',
            'model_id' => 'Vehicle Model',
            'new_car_id' => 'New Car',
            'trim_id' => 'Trim',
            'form_id' => 'Enquiry Form',
            'test_drive_form_id' => 'Test Drive Form',
            'price' => 'Price',
            'full_price' => 'Full Price',
            'deposit' => 'Deposit',
            'order' => 'Sort Order',
            'engine_size_cc' => 'Engine Size (cc)',
            'colour' => 'Colour',
            'battery_range' => '[EV] Battery Range',
            'battery_capacity_kwh' => '[EV] Battery Capacity (kWh)',
            'battery_usable_capacity_kwh' => '[EV] Battery Usable Capacity (kWh)',
            'battery_charge_time' => '[EV] Battery Charge Time',
            'battery_quick_charge_time' => '[EV] Battery Quick Charge Time',
            'battery_quick_charge_level' => '[EV] Battery Level at End of Quick Charge',
            'franchise_id' => 'Franchise',
            'fuel_type_id' => 'Fuel Type',
            'drivetrain_id' => 'Drivetrain',
            'body_style_id' => 'Body Style',
            'transmission_id' => 'Transmission',
            'new_car_type' => 'New Car Type',
            'trim' => 'Trim',
            'mpg' => 'MPG',
            'description' => 'Description',
            'youtube_video' => 'YouTube Video URL',
            't_and_cs' => 'Terms and Conditions',
            'label' => 'Label',
            'excerpt' => 'Excerpt',
            'cta_button1_label' => 'CTA Button 1 Label',
            'cta_button1_url' => 'CTA Button 1 URL',
            'cta_button2_label' => 'CTA Button 2 Label',
            'cta_button2_url' => 'CTA Button 2 URL',
            'footnote' => 'Footnote',
            'co2' => 'CO2',
            'cap_id' => 'CAP ID',
            'auto_trader_id' => 'AutoTrader ID',
            'motor_check_id' => 'Motor Check ID',
        ];

        $extra = [
            'offer_tech_data.*' => 'Tech data'
        ];

        return array_merge($columns, $extra);
    }

    /**
     * Cast restrictions for specific keys
     *
     * @param string $key
     * @return string|null
     */
    public function castRestrictions(string $key): ?string
    {
        $restrictions = [
            'uuid' => 'string',
            'published' => 'bool',
            'featured' => 'bool',
            'published_at' => 'datetime',
            'unpublished_at' => 'datetime',
        ];

        return $restrictions[$key] ?? null;
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return VehicleOffer::query();
    }
}
