<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ImaginStudioAngleSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Imagin.studio placeholder images',
                'name' => 'Angle of the vehicle',
                'config_key' => 'imagin-studio-angle',
                'type' => 'int',
                'value' => 1,
            ],
        ];
    }
}
