<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PhyronImageSync2Seeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Import videos from feed',
                'config_key' => 'image-sync-phryon-process-video',
                'type' => 'boolean',
                'value' => true,
                'description' => 'Load and set video from Phyron feed to vehicles'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Import images from feed',
                'config_key' => 'image-sync-phryon-process-images',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Load and set images from Phyron feed to vehicles'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'Phyron',
                'name' => 'Remove non-phyron images from vehicles',
                'config_key' => 'image-sync-phryon-remove-other-images',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Will remove images from other sources when importing images from Phyron'
            ],
        ];
    }
}
