<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehiclePurgeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Fully purge expired stock',
                'config_key' => 'app-old-stock-full-purge-days',
                'type' => 'int',
                'value' => 0,
                'superadmin' => true,
                'description' => 'Defines the number of days a vehicle remains in the system after being soft-deleted before being permanently removed. Set to 0 to use the system default.',
                'order' => 1,
            ],
        ];
    }
}
