<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Tenant;

class StripeTestMode extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function isApplicable(Tenant $site): bool
    {
        return !empty(Settings::get('sales-stripe-enabled'));
    }

    public function key(): string
    {
        return 'stripe_test_mode';
    }

    public function handle(): bool
    {
        $public_key = Str::contains(Settings::get('sales-stripe-public_key'), 'pk_live');
        $secret_key = Str::contains(Settings::get('sales-stripe-private_key'), 'sk_live');
        if (!$public_key) {
            $this->failure_reason = __('go-live.errors.no-live-stripe-public-key');
            return false;
        }
        if (!$secret_key) {
            $this->failure_reason = __('go-live.errors.no-live-stripe-private-key');
            return false;
        }
        return true;
    }
}
