<?php

namespace App\Http\Controllers;

use App\Http\Requests\PinnedItemRemoveRequest;
use App\Http\Requests\PinnedItemRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Collection;
use Mtc\PinnedItems\Facades\PinnedItems;
use Mtc\PinnedItems\Models\PinnedItemModel;

class PinnedItemController extends Controller
{
    /**
     * Show all items user has pinned
     *
     * @return Collection
     */
    public function show(): Collection
    {
        return PinnedItems::get(Auth::user());
    }

    /**
     * Store a pinned item (url)
     *
     * @param PinnedItemRequest $request
     * @return Collection
     */
    public function store(PinnedItemRequest $request): Collection
    {
        PinnedItems::addUrl(
            Auth::user(),
            $request->input('url'),
            $request->input('category'),
            $request->input('title'),
            $request->input('subtitle')
        );
        return PinnedItems::get(Auth::user());
    }

    /**
     * Remove a pinned item (url)
     *
     * @param PinnedItemRemoveRequest $request
     * @return bool
     */
    public function destroy(PinnedItemRemoveRequest $request, $pinned_item_id): bool
    {
        return PinnedItemModel::query()
            ->where('owner_id', Auth::id())
            ->where('owner_type', 'user')
            ->where('id', $pinned_item_id)
            ->delete();
    }
}
