<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LeaseVehicleEnquiryFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Lease Vehicles',
                'name' => 'Lease Vehicle page enquiry form',
                'config_key' => 'lease-vehicle-enquiry-form-id',
                'type' => 'string',
                'value' => null,
                'source' => 'forms',
            ],
        ];
    }
}
