<?php

namespace App\Contracts;

use Illuminate\Support\Collection;

interface SalesChannel
{
    /**
     * Check if sales channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool;

    /**
     * Name of the sales channel
     *
     * @return string
     */
    public function name(): string;

    /**
     * Export vehicle collection to a sales channel
     *
     */
    public function runScheduledExport(): void;
}
