<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeasePriceMapping;

class ImportPriceMapJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        KeyloopLeasePriceMapping::query()->updateOrCreate([
            'external_variant_id' => $item['external_variant_id'],
            'make_id' => $item['make_id'],
            'model_id' => $item['model_id'],
            'option_type' => $item['option_type'],
            'option_code' => $item['option_code'],
        ], [
            'was_recently_synced' => true,
            'price_option_code' => $item['price_option_code'],
        ]);
    }
}
