<?php

namespace App\VehicleSpec\Maps;

final class HPITechnicalFieldMap
{
    public static function all(): array
    {
        return [
            [
                'category' => 'Body',
                'description' => 'Body Type',
                'code' => 'Asset.PrimaryAssetData.DVLA.Body.Code',
                'value' => 'Asset.PrimaryAssetData.DVLA.Body.Description',
            ],
            [
                'category' => 'Drivetrain',
                'description' => 'Wheel Plan',
                'code' => 'Asset.PrimaryAssetData.DVLA.Body.WheelPlan.Code',
                'value' => 'Asset.PrimaryAssetData.DVLA.Body.WheelPlan.Description',
            ],
            [
                'category' => 'General',
                'description' => 'Colour',
                'code' => 'Asset.PrimaryAssetData.DVLA.Body.Colour.Current.Code',
                'value' => 'Asset.PrimaryAssetData.DVLA.Body.Colour.Current.Description',
            ],
            [
                'category' => 'Body',
                'description' => 'Doors',
                'value' => 'Asset.PrimaryAssetData.DVLA.Body.Doors',
            ],
            [
                'category' => 'Body',
                'description' => 'Weight',
                'value' => 'Asset.PrimaryAssetData.DVLA.Body.Weight',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine Size',
                'value' => 'Asset.PrimaryAssetData.DVLA.Engine.Size',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine Number',
                'value' => 'Asset.PrimaryAssetData.DVLA.Engine.Number',
            ],
            [
                'category' => 'Engine',
                'description' => 'Fuel Type',
                'code' => 'Asset.PrimaryAssetData.DVLA.Engine.Fuel.Code',
                'value' => 'Asset.PrimaryAssetData.DVLA.Engine.Fuel.Description',
            ],
//            [
//                'category' => 'Registration',
//                'description' => 'First Registered',
//                'value' => 'Asset.PrimaryAssetData.DVLA.KeyDates.FirstRegistered.Date',
//            ],
//            [
//                'category' => 'Registration',
//                'description' => 'Manufactured Year',
//                'value' => 'Asset.PrimaryAssetData.DVLA.KeyDates.Manufactured.Year',
//            ],
//            [
//                'category' => 'Registration',
//                'description' => 'Imported',
//                'value' => 'Asset.PrimaryAssetData.DVLA.KeyDates.IsImported',
//            ],
//            [
//                'category' => 'Registration',
//                'description' => 'Northern Ireland Origin',
//                'value' => 'Asset.PrimaryAssetData.DVLA.IsFromNorthernIreland',
//            ],
//            [
//                'category' => 'Ownership',
//                'description' => 'Previous Keepers (total)',
//                'value' => 'Asset.PrimaryAssetData.DVLA.Keepers.TotalPreviousKeepers',
//            ],
//            [
//                'category' => 'Ownership',
//                'description' => 'Last Change of Keeper',
//                'value' => 'Asset.PrimaryAssetData.DVLA.Keepers.LastChangeOfKeeperDate',
//            ],
            [
                'category' => 'Transmission',
                'description' => 'Transmission',
                'code' => 'Asset.PrimaryAssetData.SMMT.Transmission.Code',
                'value' => 'Asset.PrimaryAssetData.SMMT.Transmission.Description',
            ],
            [
                'category' => 'Body',
                'description' => 'Body (SMMT)',
                'value' => 'Asset.PrimaryAssetData.SMMT.Body.Description',
            ],
            [
                'category' => 'Body',
                'description' => 'Doors (SMMT)',
                'value' => 'Asset.PrimaryAssetData.SMMT.Body.Doors',
            ],
            [
                'category' => 'General',
                'description' => 'Market Sector Code',
                'value' => 'Asset.PrimaryAssetData.SMMT.MarketSector.Code',
            ],
            [
                'category' => 'Dimensions',
                'description' => 'Length (mm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Length',
            ],
            [
                'category' => 'Dimensions',
                'description' => 'Width (mm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Width',
            ],
            [
                'category' => 'Dimensions',
                'description' => 'Height (mm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Height',
            ],
            [
                'category' => 'Seating',
                'description' => 'Seats',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfSeats',
            ],
            [
                'category' => 'Body',
                'description' => 'Number of Doors (Main)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfDoors',
            ],
            [
                'category' => 'Body',
                'description' => 'Body Style',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.BodyStyle',
            ],
            [
                'category' => 'Drivetrain',
                'description' => 'Drive Type',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.DriveType',
            ],
            [
                'category' => 'Transmission',
                'description' => 'Gears',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfGears',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine (nominal cc)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.EngineCc',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine Model',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.EngineModelDescription',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine Location',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.EngineLocation',
            ],
            [
                'category' => 'Engine',
                'description' => 'Engine Make',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.EngineMake',
            ],
            [
                'category' => 'Engine',
                'description' => 'Aspiration',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Aspiration',
            ],
            [
                'category' => 'Engine',
                'description' => 'Cylinder Arrangement',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.CylinderArrangement',
            ],
            [
                'category' => 'Engine',
                'description' => 'Cylinders',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfCylinders',
            ],
            [
                'category' => 'Engine',
                'description' => 'Valves per Cylinder',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfValvesPerCylinder',
            ],
            [
                'category' => 'Engine',
                'description' => 'Valve Gear',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.ValveGear',
            ],
            [
                'category' => 'Engine',
                'description' => 'Bore (mm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Bore',
            ],
            [
                'category' => 'Engine',
                'description' => 'Stroke (mm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Stroke',
            ],
            [
                'category' => 'Emissions',
                'description' => 'Euro Status',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.EuroStatus',
            ],
            [
                'category' => 'General',
                'description' => 'Type Approval Category',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.TypeApprovalCategory',
            ],
            [
                'category' => 'General',
                'description' => 'Power Delivery',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.PowerDelivery',
            ],
            [
                'category' => 'General',
                'description' => 'Country of Origin',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.CountryOfOrigin',
            ],
            [
                'category' => 'Chassis',
                'description' => 'Number of Axles',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.NumberOfAxles',
            ],
            [
                'category' => 'Chassis',
                'description' => 'Wheelbase',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.Wheelbase',
            ],
            [
                'category' => 'Weights',
                'description' => 'Kerb Weight',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.KerbWeight',
            ],
            [
                'category' => 'Weights',
                'description' => 'Unladen Weight',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.UnladenWeight',
            ],
            [
                'category' => 'Weights',
                'description' => 'Gross Vehicle Weight',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.GrossVehicleWeight',
            ],
            [
                'category' => 'Weights',
                'description' => 'Gross Train Weight',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.GrossTrainWeight',
            ],
            [
                'category' => 'Weights',
                'description' => 'Gross Combined Weight',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Main.GrossCombinedWeight',
            ],
            [
                'category' => 'Engine',
                'description' => 'Primary Fuel Flag',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.PrimaryFuelFlag',
            ],
            [
                'category' => 'Engine',
                'description' => 'Power (bhp)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.PowerBhp',
            ],
            [
                'category' => 'Engine',
                'description' => 'Power (kW)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.PowerKw',
            ],
            [
                'category' => 'Engine',
                'description' => 'Power RPM',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.PowerRpm',
            ],
            [
                'category' => 'Engine',
                'description' => 'Torque (lb·ft)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.TorqueLbFt',
            ],
            [
                'category' => 'Engine',
                'description' => 'Torque (Nm)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.TorqueNm',
            ],
            [
                'category' => 'Engine',
                'description' => 'Torque RPM',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.TorqueRpm',
            ],
            [
                'category' => 'Emissions',
                'description' => 'CO₂ (g/km)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.Co2',
            ],
            [
                'category' => 'Performance',
                'description' => 'Top Speed (mph)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.MaxSpeedMph',
            ],
            [
                'category' => 'Performance',
                'description' => 'Top Speed (kph)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.MaxSpeedKph',
            ],
            [
                'category' => 'Performance',
                'description' => '0–62 mph (s)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.AccelerationMph',
            ],
            [
                'category' => 'Performance',
                'description' => '0–100 km/h (s)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.AccelerationKph',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Urban (mpg)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.UrbanColdMpg',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Extra Urban (mpg)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.ExtraUrbanMpg',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Combined (mpg)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.CombinedMpg',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Urban (l/100km)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.UrbanColdLkm',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Extra Urban (l/100km)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.ExtraUrbanLkm',
            ],
            [
                'category' => 'Fuel Economy',
                'description' => 'Combined (l/100km)',
                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.Technical.TechnicalData.CombinedLkm',
            ],
//            [
//                'category' => 'Identifiers',
//                'description' => 'CAP Code',
//                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.CAPMultiMatch.CAPMatch.CAPCode',
//            ],
//            [
//                'category' => 'Identifiers',
//                'description' => 'CAP Id',
//                'value' => 'Asset.SupplementaryAssetData.SmmtExtra.CAPMultiMatch.CAPMatch.CAPId',
//            ],
        ];
    }
}
