<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderUpsertDeletedSettings extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Send deleted vehicles',
                'config_key' => 'auto-trader-upsert-send-deleted',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Sends vehicle data even if the vehicle has been deleted.',
                'order' => 32,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Max age of deleted vehicles to send',
                'config_key' => 'auto-trader-upsert-deleted-max-age-days',
                'type' => 'number',
                'value' => 7,
                'description' => 'Specify how many days after deletion vehicles should still be sent.',
                'order' => 33,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Mark vehicles as Sold if deleted',
                'config_key' => 'auto-trader-upsert-deleted-mark-sold',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Send vehicles as Sold if they are deleted.',
                'order' => 34,
            ],
        ];
    }
}
