<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class TiktokSocialSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Social Media',
                'group' => 'Social Media Icons',
                'name' => 'TikTok',
                'config_key' => 'app-socials-tiktok',
                'value' => '',
                'type' => 'string',
                'description' => 'Link to the linked TikTok profile',
            ],
        ];
    }
}
