<?php

namespace Tests\Unit;

use App\Actions\Fortify\UpdateUserPassword;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\User;
use Tests\TestCase;

class UpdateUserPasswordTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testUpdatesPassword()
    {
        $user = User::factory()->create([
            'password' => Hash::make('test-pass')
        ]);

        $input = [
            'current_password' => 'test-pass',
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];
        (new UpdateUserPassword())->update($user, $input);
        $user->refresh();

        $this->assertTrue(password_verify('SomethingSuperStrong2#', $user->password));
    }

    public function testFailsUpdatingWithIncorrectData()
    {
        $user = User::factory()->create([
            'password' => Hash::make('test-pass')
        ]);

        $input = [
            'current_password' => 'test-pass',
            'password' => 'SomethingSuperStrong2#',
        ];
        $this->expectException(ValidationException::class);
        (new UpdateUserPassword())->update($user, $input);

        $input = [
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];
        $this->expectException(ValidationException::class);
        (new UpdateUserPassword())->update($user, $input);

        $input = [
            'current_password' => '',
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];
        $this->expectException(ValidationException::class);
        (new UpdateUserPassword())->update($user, $input);

    }
}
