<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\App;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class TaxonomyMap extends Model
{
    use CentralConnection;
    use HasFactory;

    public const MAKE = 'make';
    public const MODEL = 'model';
    public const BODY_STYLE = 'body_style';
    public const TRANSMISSION = 'transmission';
    public const FUEL_TYPE = 'fuel_type';
    public const DRIVETRAIN = 'drivetrain';

    protected $table = 'taxonomy_map';

    protected $fillable = [
        'taxonomy_type',
        'taxonomy_id',
        'term',
        'provider',
        'parent_id',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    /**
     * Relationship with morphed taxonomy
     *
     * @return MorphTo
     */
    public function taxonomy(): MorphTo
    {
        return $this->morphTo('taxonomy');
    }

    public function mapables()
    {
        return $this->hasMany(TaxonomyMapable::class);
    }
}
