<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CapIdLookupDefaultAttribute extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'Vehicle CAP ID lookup preferred attribute',
                'config_key' => 'vehicle-spec-providers-cap-default-lookup-attribute',
                'min_tier' => 'standard',
                'type' => 'string',
                'choices' => [
                    ['value' => 'vin', 'name' => 'VIN'],
                    ['value' => 'vrm', 'name' => 'Registration Number (VRM)'],
                ],
                'value' => 'vin',
                'description' => 'When looking up vehicle CAP id the selected attribute will be used if the value is set'
            ],
        ];
    }
}
