<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SantanderFinanceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn ($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander Finance Enabled',
                'config_key' => 'finance-santander-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander Finance API Username',
                'config_key' => 'finance-santander-username',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    'required_if:values.finance-santander-enabled,true',
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander Finance API Password',
                'config_key' => 'finance-santander-password',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    'required_if:values.finance-santander-enabled,true',
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander Finance Dealer Code',
                'config_key' => 'finance-santander-dealer-code',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    'required_if:values.finance-santander-enabled,true',
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander Finance Environment',
                'config_key' => 'finance-santander-environment',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => 'uat',
                'choices' => '{"uat":"UAT (Testing)","live":"Live (Production)"}',
                'validation_rules' => [
                    'required_if:values.finance-santander-enabled,true',
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander HP Product ID',
                'config_key' => 'finance-santander-hp-product-id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'description' => 'Santander product code for HP (Hire Purchase) quotes',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Santander',
                'name' => 'Santander PCP Product ID',
                'config_key' => 'finance-santander-pcp-product-id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'description' => 'Santander product code for PCP (Personal Contract Purchase) quotes',
            ],
        ];
    }
}
