<?php

namespace Tests\Unit;

use App\Facades\Settings;
use Database\Seeders\Tenant\FinanceSettingSeeder;
use Database\Seeders\Tenant\SantanderFinanceSettingSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Finance\Contracts\FinanceProvider;
use Mtc\MercuryDataModels\Finance\FinanceServiceHelper;
use Mtc\MercuryDataModels\Finance\Services\CodeWeavers;
use Mtc\MercuryDataModels\Finance\Services\EvolutionFinance;
use Mtc\MercuryDataModels\Finance\Services\IVendi;
use Mtc\MercuryDataModels\Finance\Services\SantanderFinance;
use Tests\TenantTestCase;

class FinanceServiceHelperTest extends TenantTestCase
{

    public function testInitializeCodeweavers()
    {
        $this->seedSettings();
        Settings::update('finance-codeweavers-enabled', true);
        $provider = FinanceServiceHelper::initializeForSite();
        $this->assertInstanceOf(FinanceProvider::class, $provider);
        $this->assertInstanceOf(CodeWeavers::class, $provider);
    }

    public function testInitializeIvendi()
    {
        $this->seedSettings();
        Settings::update('finance-ivendi-enabled', true);
        $provider = FinanceServiceHelper::initializeForSite();
        $this->assertInstanceOf(FinanceProvider::class, $provider);
        $this->assertInstanceOf(IVendi::class, $provider);
    }

    public function testInitializeEvolution()
    {
        $this->seedSettings();
        Settings::update('finance-evolution-enabled', true);
        $provider = FinanceServiceHelper::initializeForSite();
        $this->assertInstanceOf(FinanceProvider::class, $provider);
        $this->assertInstanceOf(EvolutionFinance::class, $provider);
    }

    public function testInitializeSantander()
    {
        $this->seedSettings();
        Settings::update('finance-santander-enabled', true);
        $provider = FinanceServiceHelper::initializeForSite();
        $this->assertInstanceOf(FinanceProvider::class, $provider);
        $this->assertInstanceOf(SantanderFinance::class, $provider);
    }

    private function seedSettings()
    {
        $this->seed(FinanceSettingSeeder::class);
        $this->seed(SantanderFinanceSettingSeeder::class);
    }
}
