<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class SettingFeatureFlags extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($data) => Setting::query()
                ->where($data['field'], $data['value'])
                ->update(['feature' => $data['feature']]));
    }

    private function data(): array
    {
        return [
            [
                'field' => 'section',
                'value' => 'Valuation',
                'feature' => 'valuations',
            ],
            [
                'field' => 'section',
                'value' => 'Sales Channels / Feeds',
                'feature' => 'sales-channels',
            ],
            [
                'field' => 'section',
                'value' => 'Sales Channels / Feeds',
                'feature' => 'sales-channels',
            ],
            [
                'field' => 'section',
                'value' => 'Offer sync',
                'feature' => 'new-vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Filter',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Sales',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Finance',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Specification / Feature Synchronization',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'AutoTrader',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Image Synchronization',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'section',
                'value' => 'Vehicle Savings',
                'feature' => 'vehicles',
            ],
            [
                'field' => 'group',
                'value' => 'Versioning',
                'feature' => 'content-management',
            ],
            [
                'field' => 'group',
                'value' => 'News',
                'feature' => 'content-management',
            ],
            [
                'field' => 'group',
                'value' => 'Blog',
                'feature' => 'content-management',
            ],
            [
                'field' => 'tab',
                'value' => 'CRM',
                'feature' => 'crm',
            ],
        ];
    }
}
