<?php

namespace App\Modules\Leasing;

use App\Modules\Leasing\Jobs\VariantOptionMapImportJob;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeaseVariantOptionMapping;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class KeyloopFleetKompactVariantOptionMapImporter extends KeyloopFleetKompactImporterBase
{
    protected array $filtered_variants = [];

    protected function filter(Collection $data): bool
    {
        if (
            array_key_exists($data['franchise-code'], $this->enabled_keyloop_makes)
            && array_key_exists($data['franchise-code'], $this->enabled_keyloop_models)
            && array_key_exists($data['model-code'], $this->enabled_keyloop_models[$data['franchise-code']])
        ) {
            return true;
        }

        return false;
    }

    protected function prepareForImport(): void
    {
        KeyloopLeaseVariantOptionMapping::query()->update([
            'was_recently_synced' => false,
        ]);
    }

    protected function importItems(Collection $data): void
    {
        $this->dispatch(new VariantOptionMapImportJob($data->map(fn ($item) => [
            'external_variant_id' => $item['variant-code'],
            'make_id' => $this->getVehicleMake($item['franchise-code']),
            'model_id' => $this->getVehicleModel($item['model-code'], $item['franchise-code']),
            'option_type' => $item['option-type'],
            'option_code' => $item['option-code'],
            'option_availability_code' => $item['availability-code'],
        ])));
    }
}
