<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoConverseSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'AutoConverse',
                'name' => 'Enabled',
                'config_key' => 'chat-autoconverse-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => 'AutoConverse live chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'AutoConverse',
                'name' => 'Client Key',
                'config_key' => 'chat-autoconverse-key',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'description' => 'AutoConverse live chat integration key.',
                'validation_rules' => [
                    "required_if:values.chat-autoconverse-enabled,true"
                ]
            ],
        ];
    }
}
