<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MotorCheckValuationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'MotorCheck',
                'name' => 'Enabled',
                'config_key' => 'valuation-motor-check-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'MotorCheck',
                'name' => 'Client Id',
                'config_key' => 'valuation-motor-check-client_id',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'MotorCheck',
                'name' => 'Client Secret',
                'config_key' => 'valuation-motor-check-client_secret',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'MotorCheck',
                'name' => 'Valuation Driver',
                'config_key' => 'valuation-motor-check-driver',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => 'auto-trader',
                'choices' => [
                    [
                        'name' => 'AutoTrader',
                        'value' => 'auto-trader',
                    ],[
                        'name' => 'VIP',
                        'value' => 'vip',
                    ]
                ],
            ],
        ];
    }
}
