<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SilverBulletSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Enabled',
                'config_key' => 'sales-silver-bullet-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '<a href="https://www.keyloop.com/sales/ecommerce" target="_blank">Keyloop eCommerce</a> integration',
                'order' => 9,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'FTP account username',
                'config_key' => 'sales-silver-bullet-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'FTP account password',
                'config_key' => 'sales-silver-bullet-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Exported file name',
                'config_key' => 'sales-silver-bullet-export-filename',
                'type' => 'string',
                'value' => tenant('name') . '.csv',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'eCommerce domain',
                'config_key' => 'sales-silver-bullet-domain',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Site name passed to eCommerce',
                'config_key' => 'sales-silver-bullet-site-name',
                'type' => 'string',
                'value' => tenant('name'),
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Marketing campaign medium to pass to eCommerce',
                'config_key' => 'sales-silver-bullet-campaign-medium',
                'type' => 'string',
                'value' => 'autonomy',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Marketing campaign to pass to eCommerce',
                'config_key' => 'sales-silver-bullet-campaign-name',
                'type' => 'string',
                'value' => 'fpa',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Default finance term',
                'config_key' => 'sales-silver-bullet-term',
                'type' => 'int',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Default finance deposit (percentage)',
                'config_key' => 'sales-silver-bullet-deposit',
                'type' => 'int',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Default finance annual mileage',
                'config_key' => 'sales-silver-bullet-annual-mileage',
                'type' => 'int',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-silver-bullet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'Keyloop Ecommerce',
                'name' => 'Verify integration',
                'config_key' => 'sales-silver-bullet-verify',
                'type' => 'verify',
                'value' => false,
            ],
        ];
    }
}
