<?php

namespace App\Reporting;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\MercuryDataModels\ReportingStat;
use Mtc\MercuryDataModels\Vehicle;

class VehiclesInStockKPI implements Arrayable
{
    public function toArray()
    {
        if (tenant()->type === 'listing') {
            $count = ReportingStat::query()
                ->where('key', 'vehicle-count')
                ->latest()
                ->first()
                ?->value ?? 0;
        }
        if (empty($count)) {
            $count = Vehicle::query()
                ->active()
                ->count();
        }
        return [
            'name' => 'Vehicles published',
            'value' => $count,
            'scope' => '',
        ];
    }
}
