<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderSmartImageManagementSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Smart Image Management',
                'name' => 'Enabled',
                'config_key' => 'auto-trader-smart-image-management-enabled',
                'type' => 'boolean',
                'value' => false,
                'superadmin' => true,
                'description' => 'Use AutoTrader Co-Driver Smart Image management to manage images.',
                'order' => 0,
            ],
        ];
    }
}
