<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarConfiguratorUrlPathSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Car Configurator',
                'name' => 'Vehicle page URL path',
                'config_key' => 'configurator-url-path',
                'type' => 'string',
                'value' => '/vehicle-configurator/{{SLUG}}',
                'order' => 1,
                'feature' => 'car-configurator',
                'min_tier' => 'enterprise',
                'description' => 'path - e.g. /vehicle-configurator/{{SLUG}} or /build/{{MAKE}}/{{MODEL}}/{{SLUG}} . '
                    . 'Supports MAKE MODEL and SLUG placeholders. Used for URL generating in API, '
                    . 'must match the implementation in theme!',
            ],
        ];
    }
}
