<?php

namespace App\Modules\ServiceBooking\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\BookingDeliveryOption;

class ListServiceDeliveryOptions extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $resource = $this->resource
                ->through(fn(BookingDeliveryOption $deliveryOption) => $this->map($deliveryOption))
                ->toArray();
            $resource['default_columns'] = [
                'status',
                'updated',
            ];
            return $resource;
        }
        $this->resource = $this->resource
            ->map(fn(BookingDeliveryOption $deliveryOption) => $this->map($deliveryOption));
        return parent::toArray($request);
    }

    /**
     * Map Menu entry
     *
     * @param BookingDeliveryOption $deliveryOption
     * @return array
     */
    private function map(BookingDeliveryOption $deliveryOption)
    {
        return [
            'id' => $deliveryOption->id,
            'title' => $deliveryOption->name,
            'disallow_delete' => $deliveryOption->meta['disallow_delete'] ?? false,
            'metaItems' => [
                'updated' => $deliveryOption->updated_at->diffForHumans(),
            ],
        ];
    }
}
