<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\Jobs\FetchImaginStudioColourData;
use App\Modules\Leasing\Jobs\FlagCheapestVariantsJob;
use App\Modules\Leasing\Jobs\GenerateFinanceJob;
use App\Modules\Leasing\Jobs\MapFuelTypesJob;
use App\Modules\Leasing\Jobs\PurgeOldLeaseDataJob;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Queue;

class RunKeyloopLeasingPostImportTasks extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leasing:run-keyloop-post-import-tasks';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Runs any tasks that need to run after a lease data import';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (Settings::get('leasing-keyloop-fleet-kompact-enabled') == false) {
            $this->output->error('Site does not have Keyloop Fleet Kompact enabled');
            return;
        }

        if (Queue::size('leasing-sync')) {
            return self::SUCCESS;
        }

        $this->dispatch(new PurgeOldLeaseDataJob());
        $this->dispatch(new GenerateFinanceJob());
        $this->dispatch(new FlagCheapestVariantsJob());
        $this->dispatch(new FetchImaginStudioColourData());
        $this->dispatch(new MapFuelTypesJob());
        return self::SUCCESS;
    }
}
