<?php

namespace App;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\MercuryDataModels\Vehicle;

class Filter extends \Mtc\Filter\Filter
{
    private string $filter_target_model = Vehicle::class;
    private string $config_key = '';

    public function setFilterTargetModel(string $filter_target_model = '')
    {
        $this->filter_target_model = $filter_target_model;
    }

    public function setConfigKey(string $config_key = '')
    {
        $this->config_key = $config_key;
    }

    /**
     * Get enabled filters
     *
     * @return Collection
     */
    public function getFilters(): Collection
    {
        if (empty($this->filters)) {
            $this->filters = collect($this->config[$this->config_key])
                ->map(fn($filter_class) => App::make(
                    $filter_class,
                    [
                        'type' => '',
                        'filter_target_model' => $this->filter_target_model,
                    ],
                ))
                ->filter(fn($filter) => $filter instanceof IsFilter);
        }

        return $this->filters;
    }
}
