<?php

namespace App\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleMake;

class MakeController extends Controller
{
    /**
     * Display a listing of vehicle makes
     *
     * @return LengthAwarePaginator
     */
    public function index(Request $request)
    {
        return VehicleMake::query()
            ->with('filterIndex')
            ->when($request->has('with-models'), fn ($query) => $query->with('models'))
            ->orderBy('name')
            ->paginate();
    }

    /**
     * Display the specified vehicle make.
     *
     * @param  VehicleMake $make
     * @return VehicleMake
     */
    public function show(VehicleMake $make)
    {
        return $make;
    }
}
