<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class SystemAlert extends Model
{
    use CentralConnection;
    use HasFactory;

    protected $fillable = [
        'alert_type',
        'last_sent_at',
        'tenant_id',
    ];

    /**
     * Treat "last_sent_at" as a datetime/Carbon instance.
     */
    protected $casts = [
        'last_sent_at' => 'datetime',
    ];

    /**
     * Optionally override the factory the model should use.
     */
    protected static function newFactory()
    {
        return \Database\Factories\SystemAlertFactory::new();
    }
}
