<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ExportFinanceFlag extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Export vehicle data to Finance Provider',
                'config_key' => 'finance-export-to-provider',
                'type' => 'boolean',
                'value' => false,
                'description' => 'To be used when system should export data to finance provider. ' .
                    'Should be disabled if a different system (DMS) provides this functionality',
                'order' => 10,
            ],
        ];
    }
}
