<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PhyronExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        $description = '<a href="https://www.phyron.com//" target="_blank">Phyron</a> feed. '
            . 'When enabled, will grant access to URL for processing images to video:<br/>'
            . 'GET ' . route('tenant.feeds.phyron', ['tenant' => tenant('id'), 'api_token' => config('auth.api_auth_token')]) . ' to list current vehicles on site<br/>';

        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Phyron',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-phyron-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Phyron',
                'name' => 'Username',
                'config_key' => 'sales-channels-phyron-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-phyron-enabled,true"
                ]
            ],
        ];
    }
}
