<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealershipDefaultTimeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Default Open Time',
                'config_key' => 'automotive-dealership-open-time',
                'type' => 'string',
                'value' => '09:00',
                'description' => 'Default value to set for open time (HH:mm)',
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Default Close Time',
                'config_key' => 'automotive-dealership-close-time',
                'type' => 'string',
                'value' => '17:30',
                'description' => 'Default value to set for close time (HH:mm)',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Default Open Days',
                'config_key' => 'automotive-dealership-open-days',
                'type' => 'string',
                'value' => 'workdays',
                'description' => 'Format used to display and manage mileages for vehicles',
                'choices' => [
                    ['value' => 'workdays', 'name' => 'Mon-Fri'],
                    ['value' => 'all', 'name' => 'Every day'],
                    ['value' => 'except-sunday', 'name' => 'Mon-Sat'],
                ],
                'order' => 12,
            ],
        ];
    }
}
