<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PlaceholderImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Placeholder Images',
                'name' => 'Vehicle',
                'config_key' => 'placeholder-image-vehicle',
                'type' => 'media',
                'value' => null,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Placeholder Images',
                'name' => 'Offer',
                'config_key' => 'placeholder-image-offer',
                'type' => 'media',
                'value' => null,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Placeholder Images',
                'name' => 'New Car',
                'config_key' => 'placeholder-image-new-car',
                'type' => 'media',
                'value' => null,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Placeholder Images',
                'name' => 'Dealership',
                'config_key' => 'placeholder-image-dealership',
                'type' => 'media',
                'value' => null,
            ],
        ];
    }
}
