<?php

namespace Tests\Unit;

use App\Facades\Settings;
use App\IntegrationRepository;
use Database\Seeders\Tenant\ChatSettingSeeder;
use Database\Seeders\Tenant\FinanceSettingSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class IntegrationRepositoryTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testGetEnabled()
    {
        $this->seed(FinanceSettingSeeder::class);
        $this->seed(ChatSettingSeeder::class);
        $repository = new IntegrationRepository();
        $enabled = $repository->getEnabled();
        $this->assertCount(0, $enabled);

        Settings::update('chat-rapid-rtc-enabled', true);
        Settings::update('finance-codeweavers-enabled', true);
        $enabled = $repository->getEnabled();
        $this->assertCount(2, $enabled);
    }
}
