<?php

namespace Tests\Tenant\Controllers;

use Mtc\MercuryDataModels\Dealership;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class DashboardControllerTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testCrm()
    {
        Dealership::factory(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.crm-dashboard'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('tiles', $response->json());
        $this->assertArrayHasKey('forms', $response->json());
        $this->assertArrayHasKey('enquiries', $response->json());
    }

    public function testContent()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.content-dashboard'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('review_pages', $response->json());
        $this->assertArrayHasKey('pages', $response->json());
        $this->assertArrayHasKey('globalContent', $response->json());
        $this->assertArrayHasKey('media', $response->json());
        $this->assertArrayHasKey('by_type', $response->json());

    }


    public function testSidebar()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.sidebar'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('pinned_items', $response->json());
        $this->assertArrayHasKey('franchises', $response->json());
        $this->assertArrayHasKey('integrations', $response->json());
        $this->assertArrayHasKey('marketing', $response->json());
    }
}
