<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use Illuminate\Support\Facades\Storage;
use Tests\TenantTestCase;

class GoogleFeedTest extends TenantTestCase
{

    protected $route;

    public function setUp(): void
    {
        parent::setUp();
        Storage::fake('public');

        $this->route = route('tenant.feeds.google', tenant('id')) . '?api_token=' . config('auth.api_auth_token');
    }

    public function testUnauthorizedAccessReturns401()
    {
        $response = $this->get(route('tenant.feeds.facebook', tenant('id')) . '?api_token=invalid');

        $response->assertStatus(401);
    }

    public function testDisabledFeedReturns404()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-google-enabled', false)
            ->andReturn(false);

        $response = $this->get($this->route);

        $response->assertStatus(404);
    }

    public function testCanViewFeed()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-google-enabled', false)
            ->andReturn(true);

        Settings::shouldReceive('get')
            ->with('sales-channels-google-store-code', null)
            ->andReturn(fake()->randomDigitNotZero())
            ->byDefault();

        $response = $this->get($this->route);

        $response->assertStatus(200);
        $response->assertSee("store_code", "title", "id", "VIN", "year", "brand", "model", "trim", "color", "interior_color", "mileage", "condition", "price");
    }

    public function testCanDownloadFeed()
    {
        Settings::shouldReceive('get')
            ->with('sales-channels-google-enabled', false)
            ->andReturn(true);

        Settings::shouldReceive('get')
            ->with('sales-channels-google-store-code', null)
            ->andReturn(fake()->randomDigitNotZero())
            ->byDefault();

        $response = $this->get($this->route . '&download=true');

        $response->assertStatus(200);
        $response->assertHeader('Content-Type', 'text/csv; charset=UTF-8');
        $response->assertHeader('Content-Disposition', 'attachment; filename=google.csv');
    }
}
