<?php

namespace App\Imports;

/*
 * For Keyloop Rev 8 stock import via csv files.
 *
 * Current set up has two csv files, both with 26 columns of stock related data.
 * The purpose of these consts (can't use enums as array keys yet) is to hopefully make the code of the keyloop stock
 * import more understandable by allowing us to replace references like $data[17] with
 * $data[KeyloopImportFields::DEALERSHIP].
 *
 */

class KeyloopImportFields
{
    // purpose unknown, currently unused in import
    public const ZERO_UNKNOWN = 0; //A
    // guess it's stock id in KeyloopRev8
    public const STOCK_ID = 1; //B
    // vehicle registration
    public const VRM = 2; //C
    // manufacturer colour (e.g. 'Spectral blue metallic', rather than 'blue')
    public const COLOUR = 3; //D
    public const FUEL_TYPE = 4; //E
    // year of manufacture
    public const YEAR = 5; //F
    // odometer reading (no measure given, so miles or km must be established from another context)
    public const ODOMETER = 6; //G
    public const BODY_STYLE = 7; //H
    // number of doors
    public const DOORS = 8; //I
    // vehicle manufacturer (can also be another value, e.g. 'OTHER')
    public const MAKE = 9; //J
    // vehicle model (can also be a non-vehicle model value, e.g. 'DEMONSTRATOR')
    public const MODEL = 10; //K
    // full string approximating make & model & derivative
    public const TITLE = 11; //L
    // engine size in cc
    public const ENGINE_CC = 12; //M
    // vehicle selling price (may need vat applied dependent on other fields)
    public const PRICE = 13; //N
    public const TRANSMISSION = 14; //O
    // Is a new (not used) vehicle
    public const IS_NEW = 15; //P
    // purpose unknown, currently unused in import
    public const SIXTEEN_UNKNOWN = 16; //Q
    // Dealership/Location name
    public const DEALERSHIP = 17; //R
    // Not sure of specific meaning, (possibly ex-demo), there are othr fields containing ('demonstrator','demo')
    public const IS_DEMO = 18; //S
    // Vehicle Identification NUmber / Chassis Number
    public const VIN = 19; //T
    public const REGISTRATION_DATE = 20; //U
    // Date of vehicle being added to stock
    public const ARRIVAL_DATE = 21; //V
    // Is VAT applicable to this vehicle (values appear to be 'Y', 'N', and also 'G'(?))
    public const VAT_APPLICABLE = 22; //W
    // purpose unknown, currently unused in import
    public const TWENTYTHREE_UNKNOWN = 23; //X
    // Availability of vehicle, e.g. available or reserved ('A', 'R')
    public const AVAILABILITY = 24; //Y
    // Descriptive string for additional 'marketing' to highlight vehicle (e.g. 'STUNNING CLE CABRIOLET')
    public const ATTENTION_GRABBER = 25; //Z
}
